#ifndef NHM_HELPER_H
#define NHM_HELPER_H

/* NHM - NodeHealthMonitor
 *
 * Author: Jean-Pierre Bogler <Jean-Pierre.Bogler@continental-corporation.com>
 *
 * Copyright (C) 2013 Continental Automotive Systems, Inc.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at http://mozilla.org/MPL/2.0/.
 */

/*******************************************************************************
*
* Header includes
*
*******************************************************************************/

#include <dlt/dlt.h>       /* DLT traces */
#include <glib-2.0/glib.h> /* Use GTypes */
#include "inc/NodeHealthMonitor.h"
#include <string.h>                         /* Use strlen                   */

#ifdef ENABLE_NHM_UNIT_TEST
#define STATIC
#else
#define STATIC static
#endif

/* the maximum length of file path */
#define FILE_PATH_LEN_LONG   256


#define G_FREE(pointer) {\
        if(NULL != (pointer))\
        {\
            g_free((pointer));\
            (pointer)=NULL;\
        }\
        }
/*******************************************************************************
*
* Exported variables
*
*******************************************************************************/

/* Export a global trace context that can be used everywhere in NHM */
DLT_IMPORT_CONTEXT(nhm_helper_trace_ctx);

char szLogBuf[256];
#define NHM_LOG(Fmt, Args...)       {                                                                       \
                                        memset(szLogBuf, 0, 256);                                           \
                                        sprintf(szLogBuf, "NHM: %s(): "Fmt, __FUNCTION__, ##Args);          \
                                        DLT_LOG(nhm_helper_trace_ctx, DLT_LOG_INFO, DLT_STRING(szLogBuf));  \
                                    }

#define NHM_DLT_LOG(Fmt, Args...)   {                                                                       \
                                        memset(szLogBuf, 0, 256);                                           \
                                        sprintf(szLogBuf, "NHM: "Fmt, ##Args);                              \
                                        DLT_LOG(nhm_helper_trace_ctx, DLT_LOG_INFO, DLT_STRING(szLogBuf));  \
                                    }


#define NHM_LOG_INFO(Fmt, Args...)  {                                                                       \
                                        memset(szLogBuf, 0, 256);                                           \
                                        sprintf(szLogBuf, "NHM: %s(): "Fmt, __FUNCTION__, ##Args);          \
                                        DLT_LOG(nhm_helper_trace_ctx, DLT_LOG_INFO, DLT_STRING(szLogBuf));  \
                                    }

#define NHM_LOG_WARN(Fmt, Args...)  {                                                                       \
                                        memset(szLogBuf, 0, 256);                                           \
                                        sprintf(szLogBuf, "NHM: %s(): "Fmt, __FUNCTION__, ##Args);          \
                                        DLT_LOG(nhm_helper_trace_ctx, DLT_LOG_WARN, DLT_STRING(szLogBuf)); \
                                    }

#define NHM_LOG_ERROR(Fmt, Args...) {                                                                       \
                                        memset(szLogBuf, 0, 256);                                           \
                                        sprintf(szLogBuf, "NHM: %s(): "Fmt, __FUNCTION__, ##Args);          \
                                        DLT_LOG(nhm_helper_trace_ctx, DLT_LOG_ERROR, DLT_STRING(szLogBuf)); \
                                    }



/************************************************************************************************************************
*
*  TYPES
*
************************************************************************************************************************/



/* function pointers to parse key file, the functions are implement in main.c with static prefix */
typedef guint   (*ConfigLoadUint)          (GKeyFile*   pKeyFile,
                                            gchar*      szGroup,
                                            gchar*      szKey,
                                            guint       dwDefaultValue);
typedef gchar** (*ConfigLoadStringArray)   (GKeyFile*   pKeyFile,
                                            gchar*      szGroup,
                                            gchar*      szKey,
                                            gchar**     pszDefaultValue);

typedef struct NHM_KEY_FILE_PARSER_S
{
    GKeyFile*               pKeyFile;
    ConfigLoadUint          pConfigLoadUint;
    ConfigLoadStringArray   pConfigLoadStringArray;
}NhmKeyFileParser;

/***********************************************************************************************************************
*
*  INTERNAL FUNCTION PROTOTYPES
*
***********************************************************************************************************************/

gboolean         nhm_helper_str_in_strv              (const gchar* str, gchar* strv[]);
gboolean         nhm_check_key_file_parser           (NhmKeyFileParser*   pParser);
gchar *          nhm_get_process_name_from_full_path (const gchar *pExePath);
NhmErrorStatus_e nhm_main_request_restart            (NsmRestartReason_e  restart_reason, guint restart_type);





#endif /* NHM_HELPER_H */
